/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef   HAVE_UNISTD_H
#include <unistd.h>
#endif
#include "udm_config.h"
#include "udmsearch.h"
#include "udm_xmalloc.h"

/* This should be last include */
#ifdef DMALLOC
#include "dmalloc.h"
#endif


#ifndef UDM_CONF_DIR
#define UDM_CONF_DIR "/usr/local/mnogosearch/etc/"
#endif


/******************** Misc functions *********************************/

static void ParseQStringUnescaped(UDM_VARLIST *vars, const char *qstring){
	char *tok, *lt; 
	char qs[1024];
	
	strncpy(qs,qstring,sizeof(qs));
	qs[sizeof(qs)-1]='\0';
	tok=strtok_r(qs,"&",&lt);
	while(tok){
		char *arg=strchr(tok,'=');
		if(arg)*arg++='\0';
		UdmVarListAddStr(vars,tok,arg?arg:"");
		tok=strtok_r(NULL,"&",&lt);
	}
}

static char * BuildPageURL(UDM_VARLIST * vars,char * dst){
	int i,nargs=0;
	char * end=dst;

	for(i=0;i<vars->nvars;i++){
		strcpy(end,nargs?"&":"?");
		end++;
		strcpy(end,vars->Var[i].name);
			
		end=end+strlen(end);
		strcpy(end,"=");end++;
		strcpy(end,vars->Var[i].val);
			
		end=end+strlen(end);
		nargs++;
	}
	return NULL;
}


/*****************************************************************/

int main(int argc, char ** argv){
	const char	*env, *bcharset, *lcharset;
	const char	*qw=NULL;
	char		template_name[1024]="";
	char		*query_string = NULL;
	char		self[1024]="";
	char		*nav = NULL;
	char		*url = NULL;
	char		search_time[100]="";
	char		*searchwords=NULL;
	char		*storedstr=NULL;
	int		res,httpd=0,catcolumns=0;
	int		page1,page2,npages,ppp=10;
	int		page_size,page_number;
	size_t		i, len, swlen =0, nav_len;
	UDM_ENV		*Env;
	UDM_AGENT	*Agent;
	UDM_RESULT	*Res;
	UDM_VARLIST	query_vars;
	UDM_VARLIST	tmpl;
	
	
	/* Output Content-type if under HTTPD	 */
	/* Some servers do not pass QUERY_STRING */
	/* if the query was empty, so check	 */
	/* REQUEST_METHOD too     to be safe     */
	
	httpd=(getenv("QUERY_STRING")||getenv("REQUEST_METHOD"));
	
	UdmInit();
	Env=UdmEnvInit(NULL);
	UdmVarListInit(&tmpl);
	UdmVarListInit(&query_vars);
	
	/* Detect self and template name */
	if((env=getenv("UDMSEARCH_TEMPLATE")))
		strncpy(template_name,env,sizeof(template_name)-1);
	
	if((env=getenv("UDMSEARCH_SELF")))
		strncpy(self,env,sizeof(self)-1);
	
	if((env=getenv("QUERY_STRING"))){
	        query_string = (char*)realloc(query_string, strlen(env) + 1);
		url = (char *)realloc(url, strlen(env) + UDM_URLSIZE);
		strncpy(query_string, env, strlen(env));
		if((env=getenv("REDIRECT_STATUS"))){

			/* Check Apache internal redirect  */
			/* via   "AddHandler" and "Action" */
			if(!self[0]){
				strncpy(self,(env=getenv("REDIRECT_URL"))?env:"search.cgi",sizeof(self)-1);
			}
			if(!template_name[0]){
				strncpy(template_name,(env=getenv("PATH_TRANSLATED"))?env:"",sizeof(template_name)-1);
			}
		}else{
			/* CGI executed without Apache internal redirect */

			/* Detect $Self variable with OS independant SLASHES */
			if(!self[0]){
				strncpy(self,(env=getenv("SCRIPT_NAME"))?env:"search.cgi",sizeof(self)-1);
			}

			if(!template_name[0]){
				char *s,*e;
				
				/*This is with OS specific SLASHES */
				env=((env=getenv("SCRIPT_FILENAME"))?env:"search.cgi");

				if(strcmp(UDM_CONF_DIR,".")){
					/* Take from the config directory */
					snprintf(template_name,sizeof(template_name)-1,"%s/%s", UDM_CONF_DIR,(s=strrchr(env,UDMSLASH))?(s+1):(self));
				}else{
					/* Take from the current directory */
					strncpy(template_name,env,sizeof(template_name)-1);
				}

				/* Find right slash if it presents */
				s=((s=strrchr(template_name,UDMSLASH))?s:template_name);

				/* Find .cgi substring */
				if((e=strstr(s,".cgi"))){
					/* Replace ".cgi" with ".htm" */
					e[1]='h';e[2]='t';e[3]='m';
				}else{
					strcpy(template_name,"search.htm");
				}
			}
		}
	}else{
		/* Executed from command line     */
		/* or under server which does not */
		/* pass an empty QUERY_STRING var */
		if(argv[1]) {
		  query_string = (char*)realloc(query_string, strlen(argv[1]) + 10);
		  sprintf(query_string, "q=%s", argv[1]);
		  url = (char *)realloc(url, strlen(argv[1]) + UDM_URLSIZE);
		} else {
		  query_string = (char*)realloc(query_string, 1024);
		  sprintf(query_string, "q=");
		  url = (char *)realloc(url, UDM_URLSIZE);
		}
		if(!template_name[0])snprintf(template_name,sizeof(template_name),"%s/%s", UDM_CONF_DIR,"search.htm");
	}
	
	if((res=UdmTemplateLoad(Env,&Env->Vars,template_name,&tmpl))){
		if(httpd)printf("Content-Type: text/plain\r\n\r\n");
		printf("%s\n",Env->errstr);
		UdmVarListFree(&tmpl);
		UdmEnvFree(Env);
		return(0);
	}
	UdmSetLogLevel(Env,UdmVarListFindInt(&Env->Vars,"LogLevel",0));
	UdmOpenLog("search.cgi",Env,!httpd);
	
	Agent=UdmAgentInit(NULL,Env,0);
	UdmLog(Agent,UDM_LOG_ERROR,"search.cgi started with '%s'",template_name);
	
	/* This is for query tracking */
	UdmVarListAddStr(&Env->Vars,"QUERY_STRING",query_string);
	UdmVarListAddStr(&Env->Vars,"self",self);
	env = getenv("REMOTE_ADDR");
	UdmVarListAddStr(&Env->Vars, "IP", env?env:"");
	
	/* Hack for Russian Apache from apache.lexa.ru  */
	/* QUERY_STRING is already converted to server  */
	/* character set. We must print original query  */
	/* string instead however. Under usual apache   */ 
	/* we'll use QUERY_STRING. Note that query_vars */
	/* list will contain not unescaped values, so   */
	/* we don't have to escape them when displaying */
	env = getenv("CHARSET_SAVED_QUERY_STRING");
	ParseQStringUnescaped(&query_vars,env?env:query_string);
	
	/* Unescape and save variables from QUERY_STRING */
	/* Env->Vars will have unescaped values however  */
	UdmParseQueryString(Agent,&Env->Vars,query_string);
	
	bcharset=UdmVarListFindStr(&Env->Vars,"BrowserCharset","iso-8859-1");
	Env->bcs=UdmGetCharSet(bcharset);
	lcharset=UdmVarListFindStr(&Env->Vars,"LocalCharset","iso-8859-1");
	Env->lcs=UdmGetCharSet(lcharset);
	ppp=UdmVarListFindInt(&Env->Vars,"PagesPerScreen",10);
	
	if(httpd){
		if(!Env->bcs){
			printf("Content-Type: text/plain\r\n\r\n");
			printf("Unknown BrowserCharset '%s' in template '%s'\n",bcharset,template_name);
			exit(0);
		}else if(!Env->lcs){
			printf("Content-Type: text/plain\r\n\r\n");
			printf("Unknown LocalCharset '%s' in template '%s'\n",lcharset,template_name);
			exit(0);
		}else{
			printf("Content-type: text/html; charset=%s\r\n\r\n",bcharset);
		}
	}else{
		if(!Env->bcs){
			printf("Unknown BrowserCharset '%s' in template '%s'\n",bcharset,template_name);
			exit(0);
		}
		if(!Env->lcs){
			printf("Unknown LocalCharset '%s' in template '%s'\n",lcharset,template_name);
			exit(0);
		}
	}
	
	/* These parameters taken from "variable section of template"*/
	if((env=UdmVarListFindStr(&Env->Vars,"VarDir",NULL))){
		snprintf(Agent->Conf->vardir,sizeof(Agent->Conf->vardir)-1,"%s%s",env,UDMSLASHSTR);
	}
	
	res=UdmVarListFindInt(&Env->Vars,"np",0)*UdmVarListFindInt(&Env->Vars,"ps",20);
	UdmVarListAddInt(&Env->Vars,"pn",res);

	catcolumns=atoi(UdmVarListFindStr(&Env->Vars,"CatColumns",""));
	
	if(catcolumns){
		UDM_CATEGORY C;
		
		bzero(&C,sizeof(C));
		strcpy(C.addr,UdmVarListFindStr(&Env->Vars,"cat",""));
		if(!UdmCatAction(Agent,&C,UDM_CAT_ACTION_LIST,Env->db)){
			size_t n=1;
			char catlist[1024]="";
			
			sprintf(catlist,"<table>\n");
			for(i=0;i<C.ncategories;i++){
				if(n==1){
					sprintf(catlist+strlen(catlist),"<tr>\n");
				}
				sprintf(catlist+strlen(catlist),"<td><a href=\"?cat=%s\">%s</A></td><td width=60>&nbsp;</td>\n",
						C.Category[i].path,
						C.Category[i].name);
				if(n==catcolumns){
					sprintf(catlist+strlen(catlist),"</tr>\n");
					n=1;
				}else{
					n++;
				}
			}
			sprintf(catlist+strlen(catlist),"</table>\n");
			UdmVarListAddStr(&Env->Vars,"CS",catlist);
		}else{
			if(UdmEnvErrCode(Agent->Conf)){
				UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
				UdmVarListAddStr(&Env->Vars,"E",UdmEnvErrMsg(Agent->Conf));
				UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "error");
				goto end;
			}
		}

		bzero(&C,sizeof(C));
		strcpy(C.addr,UdmVarListFindStr(&Env->Vars,"cat",""));
		if(!UdmCatAction(Agent,&C,UDM_CAT_ACTION_PATH,Env->db)){
			char catpath[1024]="";
			
			for(i=0;i<C.ncategories;i++){
				sprintf(catpath+strlen(catpath),"/<a href=\"?cat=%s\">%s</A>",
					C.Category[i].path,
					C.Category[i].name);
			}
			UdmVarListAddStr(&Env->Vars,"CP",catpath?catpath:"");
		}else{
			if(UdmEnvErrCode(Agent->Conf)){
				UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
				UdmVarListAddStr(&Env->Vars,"E",UdmEnvErrMsg(Agent->Conf->db));
				UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "error");
				goto end;
			}
		}
	}
	
	
	/* Now start displaying template*/
	UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
	
	qw=UdmVarListFindStr(&Env->Vars,"q","");
	
	if(!qw[0]){
		UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "noquery");
		goto end;
	}
	
	if(NULL==(Res=UdmFind(Agent,qw)) || Env->errcode){
		if(UdmEnvErrCode(Agent->Conf)){
			UdmVarListAddStr(&Env->Vars,"E",UdmEnvErrMsg(Agent->Conf));
			UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "error");
		}
		goto end;
	}
	
	for(len = i = 0; i < Res->WWList.nwords; i++) 
	  len += Res->WWList.Word[i].len;
	
	
	{ 
	  size_t wsize=(1+len*15)*sizeof(char);
	  char *wordinfo = (char*) malloc(wsize);
	  int corder = -1, ccount = 0;
	  
	  *wordinfo = '\0';
	  
	  for(i = 0; i < Res->WWList.nwords; i++){
	    if ((Res->WWList.Word[i].count > 0) || (Res->WWList.Word[i].origin == UDM_WORD_ORIGIN_QUERY)) {
		if(wordinfo[0]) strcat(wordinfo,", ");
		sprintf(UDM_STREND(wordinfo)," %s : %d", Res->WWList.Word[i].word, Res->WWList.Word[i].count);
	    } else if (Res->WWList.Word[i].origin == UDM_WORD_ORIGIN_STOP) {
		if(wordinfo[0]) strcat(wordinfo,", ");
		sprintf(UDM_STREND(wordinfo)," %s : stopword", Res->WWList.Word[i].word);
	    }
	  }
	  
	  UdmVarListAddStr(&Env->Vars, "WE", wordinfo);
	  
	  *wordinfo = '\0';
	  for(i = 0; i < Res->WWList.nwords; i++){
	    if (Res->WWList.Word[i].order != corder) {
		if(wordinfo[0]) {
		  sprintf(UDM_STREND(wordinfo)," / %d, ", ccount);
		}
		ccount = Res->WWList.Word[i].count;
		if (Res->WWList.Word[i].origin == UDM_WORD_ORIGIN_STOP) {
		  sprintf(UDM_STREND(wordinfo)," %s : stopword", Res->WWList.Word[i].word);
		} else {
		  sprintf(UDM_STREND(wordinfo)," %s : %d", Res->WWList.Word[i].word, Res->WWList.Word[i].count);
		  corder = Res->WWList.Word[i].order; 
		}
	    } else {
		ccount += Res->WWList.Word[i].count;
	    }
	  }
	  if (Res->WWList.nwords) {
		  sprintf(UDM_STREND(wordinfo)," / %d", ccount);
	  }
	  
	  UdmVarListAddStr(&Env->Vars, "W", wordinfo);
	  UDM_FREE(wordinfo);
	}
	
	UdmVarListAddInt(&Env->Vars,"first",(int)Res->first);
	UdmVarListAddInt(&Env->Vars,"last",(int)Res->last);
	UdmVarListAddInt(&Env->Vars,"total",(int)Res->total_found);
	sprintf(search_time,"%.3f",((double)Res->work_time)/1000);
	UdmVarListAddStr(&Env->Vars,"SearchTime",search_time);
	
	if(!Res->num_rows){
		UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "notfound");
		goto freeres;
	}
	
	page_size   = UdmVarListFindInt(&Agent->Conf->Vars,"ps",20);
	page_number = UdmVarListFindInt(&Agent->Conf->Vars,"np",0);
	
	for (i = 0; i < Res->WWList.nwords; i++) {
		swlen += Res->WWList.Word[i].len + 2;
	}
	if ((searchwords = UdmXmalloc(swlen)) != NULL) {
		int z=0;
		for (i = 0; i < Res->WWList.nwords; i++) {
			if (Res->WWList.Word[i].count > 0) {
				sprintf(UDM_STREND(searchwords), (z)?"+%s":"%s", Res->WWList.Word[i].word);
				z++;
			}
		}
	}
	storedstr = UdmXmalloc(10*(swlen + UDM_URLSIZE) + 10);
	
	npages=(Res->total_found/(page_size?page_size:20))+1;
	page1=page_number-ppp/2;
	page2=page_number+ppp/2;
	if(page1<0){
		page2-=page1;
		page1=0;
	}else
	if(page2>npages){
		page1-=(page2-npages);
		page2=npages;
	}
	if(page1<0)page1=page1=0;
	if(page2>npages)page2=npages;
	nav = (char *)realloc(nav, nav_len = (size_t)(page2 - page1 + 2) * (UDM_URLSIZE + 1024)); 
	                                                    /* !!! 1024 - limit for navbar0/navbar1 template size */ 
	nav[0] = '\0';
	
	/* build NL NB NR */
	for(i=page1;i<page2;i++){
		UdmVarListReplaceInt(&query_vars,"np",(int)i);
		BuildPageURL(&query_vars,url);
		UdmVarListReplaceStr(&Env->Vars,"NH",url);
		UdmVarListReplaceInt(&Env->Vars,"NP",(int)(i+1));
		UdmTemplatePrint(Agent, NULL, UDM_STREND(nav), nav_len - (nav - UDM_STREND(nav)), &Env->Vars,&tmpl,
				 (i == page_number)?"navbar0":"navbar1");
	}
	UdmVarListAddStr(&Env->Vars,"NB",nav);
	
	UdmVarListReplaceInt(&query_vars,"np",page_number-1);
	BuildPageURL(&query_vars,url);
	UdmVarListReplaceStr(&Env->Vars,"NH",url);
	
	if(Res->first==1){/* First page */
		UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navleft_nop");
		UdmVarListReplaceStr(&Env->Vars,"NL",nav);
	}else{
		UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navleft");
		UdmVarListReplaceStr(&Env->Vars,"NL",nav);
	}
	
	UdmVarListReplaceInt(&query_vars,"np",page_number+1);
	BuildPageURL(&query_vars,url);
	UdmVarListReplaceStr(&Env->Vars,"NH",url);
	
	if(Res->last==Res->total_found){/* Last page */
		UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navright_nop");
		UdmVarListReplaceStr(&Env->Vars,"NR",nav);
	}else{
		UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navright");
		UdmVarListReplaceStr(&Env->Vars,"NR",nav);
	}
	
	UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars,&tmpl, "restop");

	for(i=0;i<Res->num_rows;i++){
		UDM_DOCUMENT	*Doc=&Res->Doc[i];
		UDM_ALIAS	*Alias;
		UDM_CATEGORY	C;
		char		clist[2048]=""; /* FIXME */
		char		aliastr[UDM_URLSIZE];
		const char	*u, *dm;
		char		*eu, *edm, *Excerpt;
		size_t		cl,sc;
		const char	*al, *sec;
		int		dc_url_id=UdmVarListFindInt(&Doc->Sections,"ID",0);
		int		dc_origin_id=UdmVarListFindInt(&Doc->Sections,"Origin-ID",0);
		
		if(dc_origin_id)continue;
		
		UdmVarListEnter(&Env->Vars);
		
		for(cl=0;cl<Res->num_rows;cl++){
			UDM_DOCUMENT	*Clone=&Res->Doc[cl];
			int		cl_origin_id=UdmVarListFindInt(&Clone->Sections,"Origin-ID",0);
			
			if ((dc_url_id == cl_origin_id) && cl_origin_id){
				size_t	secnum;
				
				UdmVarListEnter(&Env->Vars);
				for(secnum=0;secnum<Clone->Sections.nvars;secnum++){
					UDM_VAR	*var=&Clone->Sections.Var[secnum];
					UdmVarListAdd(&Env->Vars,var);
				}
				UdmTemplatePrint(Agent, NULL, clist + strlen(clist), sizeof(clist) - strlen(clist), 
						 &Env->Vars, &tmpl, "clone");
				UdmVarListLeave(&Env->Vars);
			}
		}
		
		UdmVarListAddStr(&Env->Vars,"CL",clist);
		UdmVarListAddInt(&Env->Vars,"ID",dc_url_id);
		
		al=UdmVarListFindStr(&Doc->Sections,"URL","");
		if((Alias=UdmAliasFind(&Agent->Conf->Aliases,al,0,NULL))){
			snprintf(aliastr,sizeof(aliastr),"%s%s",Alias->replace,al+strlen(Alias->match.pattern));
		}else{
			snprintf(aliastr,sizeof(aliastr),"%s",al);
		}
		UdmVarListAddStr(&Env->Vars,"URL",aliastr);
		
		/* Pass all found user-defined sections */
		for(sc=0;sc<Doc->Sections.nvars;sc++){
			UDM_VAR *S=&Doc->Sections.Var[sc];
			UdmVarListAddStr(&Env->Vars,S->name,S->val);
		}
		
		/* temporary skip large files */
		/* Excerpt = (Doc->size < 200000) ? UdmExcerptDoc(Agent, Res, Doc, 256) : NULL;*/
		
		al = UdmVarListFindStr(&Doc->Sections, "URL", "");
		UdmVarListReplaceInt(&Doc->Sections, "STORED_ID", UdmCRC32(al, strlen(al)));
		Excerpt = UdmExcerptDoc(Agent, Res, Doc, 256);
		
		if (Excerpt != NULL) {
			char *HlExcerpt = UdmHlConvert(&Res->WWList, Excerpt, Env->lcs, Env->bcs);
			UdmVarListReplaceInt(&Env->Vars,"ST",1);
			UdmVarListReplaceStr(&Env->Vars,"body",HlExcerpt);
			UDM_FREE(Excerpt);
			UDM_FREE(HlExcerpt);
		} else {
			UdmVarListReplaceInt(&Env->Vars,"ST",0);
		}
		
		bzero(&C,sizeof(C));
		strcpy(C.addr,UdmVarListFindStr(&Doc->Sections,"Category",""));
		if(catcolumns && !UdmCatAction(Agent,&C,UDM_CAT_ACTION_PATH,Env->db)){
			char catpath[1024]="";
			size_t c;
			
			for(c=0;c<C.ncategories;c++){
				sprintf(catpath+strlen(catpath)," &gt; <A HREF=\"?cat=%s\">%s</A> ",
					C.Category[c].path,
					C.Category[c].name);
			}
			UdmVarListAddStr(&Env->Vars,"DY",catpath);
		}
		
		/* DE is DD or DT */
		sec=UdmVarListFindStr(&Env->Vars,"meta.description","");
		if(sec[0])
			UdmVarListReplaceStr(&Env->Vars,"DE",sec);
		else{
			sec=UdmVarListFindStr(&Env->Vars,"Body","");
			UdmVarListReplaceStr(&Env->Vars,"DE",sec);
		}
		
		/* DT is DT or DU */
		sec=UdmVarListFindStr(&Env->Vars,"title","");
		if(sec[0])
			UdmVarListReplaceStr(&Env->Vars,"DT",sec);
		else{
			sec=UdmVarListFindStr(&Env->Vars,"URL","");
			UdmVarListReplaceStr(&Env->Vars,"DT",sec);
		}
		
		u =  UdmVarListFindStr(&Env->Vars, "URL", "");
		eu = (char*)malloc(strlen(u)*10 + 10);
		UdmEscapeURL(eu, u);
		dm = UdmVarListFindStr(&Env->Vars, "Last-Modified", "");
		edm = (char*)malloc(strlen(dm)*10 + 10);
		UdmEscapeURL(edm, dm);
		snprintf(storedstr, 10*(swlen + UDM_URLSIZE), "%s?rec_id=%u&DM=%s&DS=%d&L=%s&CS=%s&DU=%s&q=%s",
			 UdmVarListFindStr(&Env->Vars, "StoredocURL", "/cgi-bin/storedoc.cgi"),
			 UdmVarListFindInt(&Doc->Sections, "STORED_ID", 0),
			 edm,
			 UdmVarListFindInt(&Env->Vars, "DS", 0),
			 UdmVarListFindStr(&Env->Vars,"Content-Language",""),
			 UdmVarListFindStr(&Env->Vars,"Charset",""),
			 eu,
			 searchwords
			 );
		free(eu);
		free(edm);
		UdmVarListAddStr(&Env->Vars, "stored_href", storedstr);
		
		if (UdmVarListFindInt(&Env->Vars, "ST", 0)) {
			UdmTemplatePrint(Agent, NULL, clist, sizeof(clist), &Env->Vars, &tmpl, "stored");
			UdmVarListAddStr(&Env->Vars, "STORED", clist);
		}
		UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "res");
		
		UdmVarListLeave(&Env->Vars);
	}
	UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "resbot");
	UDM_FREE(searchwords);
	UDM_FREE(storedstr);
	
freeres:
	UdmResultFree(Res);
	
end:
	UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "bottom");
	
	UdmVarListFree(&tmpl);
	UdmAgentFree(Agent);
	UdmEnvFree(Env);
	UDM_FREE(query_string);
	UDM_FREE(url);
	UDM_FREE(nav);
	
	return(0);
}
